<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title_ar')->nullable();
            $table->string('title_en')->nullable();
            $table->text('excerpt_ar')->nullable(); // ملخص قصير
            $table->text('excerpt_en')->nullable();
            $table->longText('content_ar')->nullable(); // محتوى كامل
            $table->longText('content_en')->nullable();
            $table->string('image')->nullable(); // صورة المقال
            $table->boolean('is_active')->default(1);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
