
<?php $__env->startSection('title','تعديل السلايدر'); ?>

<?php $__env->startSection('css'); ?>
<style>
    .slider-form-card {
        background-color: #fff;
        border-radius: 15px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        padding: 25px;
    }

    .form-section-title {
        font-size: 16px;
        font-weight: 600;
        color: #0d6efd;
        margin-bottom: 15px;
        border-bottom: 2px solid #e9ecef;
        padding-bottom: 5px;
    }

    label.form-label {
        font-weight: 500;
        color: #333;
    }

    input.form-control,
    textarea.form-control,
    select.form-select {
        border-radius: 10px;
        padding: 10px 14px;
        min-height: 45px;
    }

    .slider-preview {
        border-radius: 10px;
        border: 1px solid #ddd;
        padding: 5px;
        max-width: 120px;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
<div class="page-header py-3 px-3 mt-3 mb-3 bg-white shadow-sm rounded-3 border d-flex justify-content-between align-items-center flex-wrap gap-3" style="direction: rtl;">
    <div class="d-flex flex-column">
        <h4 class="content-title mb-1 fw-bold text-primary">
            <i class="bx bx-images"></i> تعديل السلايدر
        </h4>
        <small class="text-muted">قم بتعديل بيانات السلايدر</small>
    </div>

    <div>
        <a href="<?php echo e(route('sliders.index')); ?>" class="btn btn-secondary btn-sm d-flex align-items-center gap-1">
            <i class="bx bx-arrow-back fs-5"></i>
            <span>رجوع</span>
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="slider-form-card">
    <form method="POST" action="<?php echo e(route('sliders.update',$slider->id)); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="form-section mb-4">
            <h6 class="form-section-title">🖼️ بيانات السلايدر</h6>

            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">العنوان (عربي)</label>
                    <input type="text" name="title_ar" class="form-control"
                           value="<?php echo e(old('title_ar',$slider->title_ar)); ?>" required>
                </div>

                <div class="col-md-6">
                    <label class="form-label">العنوان (إنجليزي)</label>
                    <input type="text" name="title_en" class="form-control"
                           value="<?php echo e(old('title_en',$slider->title_en)); ?>">
                </div>

                <div class="col-md-6">
                    <label class="form-label">الوصف (عربي)</label>
                    <textarea name="description_ar" class="form-control"
                              rows="3"><?php echo e(old('description_ar',$slider->description_ar)); ?></textarea>
                </div>

                <div class="col-md-6">
                    <label class="form-label">الوصف (إنجليزي)</label>
                    <textarea name="description_en" class="form-control"
                              rows="3"><?php echo e(old('description_en',$slider->description_en)); ?></textarea>
                </div>

                <div class="col-md-6">
                    <label class="form-label">صورة السلايدر</label>
                    <input type="file" name="image" class="form-control" accept="image/*">

                    <?php if($slider->image): ?>
                        <div class="mt-2">
                            <small class="text-muted d-block mb-1">الصورة الحالية:</small>
                            <img src="<?php echo e(asset('storage/'.$slider->image)); ?>" class="slider-preview">
                        </div>
                    <?php endif; ?>
                </div>

                <div class="col-md-6">
                    <label class="form-label">الحالة</label>
                    <select name="is_active" class="form-select">
                        <option value="1" <?php echo e($slider->is_active ? 'selected' : ''); ?>>مفعّل</option>
                        <option value="0" <?php echo e(!$slider->is_active ? 'selected' : ''); ?>>غير مفعّل</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-end gap-2 mt-4">
            <button type="submit" class="btn btn-primary" style="background-color:#c1953e; border:none;">
                <i class="bx bx-save"></i> حفظ التعديلات
            </button>

            <a href="<?php echo e(route('sliders.index')); ?>" class="btn btn-light border">
                <i class="bx bx-x-circle"></i> إلغاء
            </a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Filters\resources\views/sliders/edit.blade.php ENDPATH**/ ?>