<?php $__env->startSection('title', 'عرض الصفحة - ' . $appPage->name); ?>

<?php $__env->startSection('css'); ?>
<style>
.phone-preview {
    width: 320px;
    height: 650px;
    border: 10px solid #000;
    border-radius: 40px;
    overflow: hidden;
    margin: 30px auto;
    box-shadow: 0 10px 25px rgba(0,0,0,0.25);
    position: relative;
}
.phone-top-notch {
    width: 160px;
    height: 25px;
    background: #000;
    border-radius: 0 0 20px 20px;
    position: absolute;
    top: -1px;
    left: 50%;
    transform: translateX(-50%);
}
.phone-screen {
    width: 100%;
    height: 100%;
    position: relative;
    font-family: 'Cairo', sans-serif;
    background-color: <?php echo e($appPage->background_color ?? '#fff'); ?>;
    color: <?php echo e($appPage->text_color ?? '#000'); ?>;
}

/* ✅ اللوجو أعلى اليمين */
.phone-logo {
    position: absolute;
    top: 20px;
    right: 20px;
    width: 70px;
    height: 70px;
    object-fit: contain;
    z-index: 10;
}

/* ✅ منطقة البانر */
.banner-area {
    position: absolute;
    top: 0;
    width: 100%;
    height: 45%;
    background-color: <?php echo e($appPage->banner_color ?? $appPage->background_color ?? '#fff'); ?>;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
}

/* ✅ صورة البانر في المنتصف */
.banner-area img {
    max-width: 90%;
    max-height: 80%;
    object-fit: contain;
}

/* ✅ النص أسفل البانر */
.text-overlay {
    position: absolute;
    bottom: 80px;
    left: 50%;
    transform: translateX(-50%);
    background: rgba(255,255,255,0.85);
    border-radius: 20px;
    padding: 20px;
    width: 85%;
    text-align: center;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}
.text-overlay h5 {
    font-weight: bold;
    font-size: 18px;
    margin-bottom: 10px;
}
.text-overlay p {
    font-size: 14px;
    color: #333;
}

/* ✅ الزر */
.phone-button {
    margin-top: 15px;
    padding: 10px 25px;
    border: none;
    border-radius: 25px;
    background-color: <?php echo e($appPage->button_color ?? '#c1953e'); ?>;
    color: <?php echo e($appPage->button_text_color ?? '#fff'); ?>;
    font-size: 15px;
    font-weight: bold;
    cursor: pointer;
    box-shadow: 0 3px 6px rgba(0,0,0,0.2);
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
<div class="page-header py-3 px-3 mt-3 mb-3 bg-white shadow-sm rounded-3 border d-flex justify-content-between align-items-center" style="direction: rtl;">
    <div>
        <h4 class="fw-bold text-primary mb-1"><i class="bx bx-show"></i> عرض الصفحة</h4>
        <small class="text-muted">معاينة شكل الصفحة داخل الهاتف</small>
    </div>
    <div>
        <a href="<?php echo e(route('app_pages.index')); ?>" class="btn btn-secondary btn-sm"><i class="bx bx-arrow-back"></i> رجوع</a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="text-center mb-4">
    <h5 class="fw-bold"><?php echo e($appPage->title_ar ?? $appPage->name); ?></h5>
    <span class="badge bg-<?php echo e($appPage->is_active ? 'success' : 'danger'); ?>">
        <?php echo e($appPage->is_active ? 'نشطة' : 'غير نشطة'); ?>

    </span>
</div>


<div class="phone-preview">
    <div class="phone-top-notch"></div>

    <div class="phone-screen">

        
        <?php if($appPage->logo): ?>
            <img src="<?php echo e(asset('storage/'.$appPage->logo)); ?>" alt="Logo" class="phone-logo">
        <?php endif; ?>

        
        <?php if($appPage->has_banner): ?>
            <div class="banner-area">
                <?php if($appPage->banner_image): ?>
                    <img src="<?php echo e(asset('storage/'.$appPage->banner_image)); ?>" alt="Banner">
                <?php endif; ?>
            </div>
        <?php endif; ?>

        
        <div class="text-overlay">
            <?php if($appPage->title_ar): ?>
                <h5><?php echo e($appPage->title_ar); ?></h5>
            <?php endif; ?>
            <?php if($appPage->description_ar): ?>
                <p><?php echo $appPage->description_ar; ?></p>
            <?php endif; ?>
            <button class="phone-button">زر تجريبي</button>
        </div>
    </div>
</div>


<div class="mt-5 card p-3 shadow-sm">
    <h5 class="fw-bold text-primary mb-3">تفاصيل الصفحة</h5>
    <ul class="list-group list-group-flush">
        <li class="list-group-item"><strong>الاسم:</strong> <?php echo e($appPage->name); ?></li>
        <li class="list-group-item"><strong>النوع:</strong> <?php echo e($appPage->type); ?></li>
        <li class="list-group-item"><strong>العنوان بالعربية:</strong> <?php echo e($appPage->title_ar ?? '-'); ?></li>
        <li class="list-group-item"><strong>العنوان بالإنجليزية:</strong> <?php echo e($appPage->title_en ?? '-'); ?></li>
        <li class="list-group-item"><strong>الوصف بالعربية:</strong> <?php echo e($appPage->description_ar ?? '-'); ?></li>
        <li class="list-group-item"><strong>الوصف بالإنجليزية:</strong> <?php echo e($appPage->description_en ?? '-'); ?></li>
        <li class="list-group-item"><strong>كود JSON:</strong>
            <pre class="mb-0" style="white-space: pre-wrap; background:#f8f9fa; border-radius:6px; padding:8px;"><?php echo e($appPage->layout_json ?? '{}'); ?></pre>
        </li>
    </ul>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Thamn\resources\views/app_pages/show.blade.php ENDPATH**/ ?>