<?php $__env->startSection('title', 'الأدوار والصلاحيات'); ?>

<?php $__env->startSection('css'); ?>
<!-- Datatables -->
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/buttons.bootstrap5.min.css')); ?>" rel="stylesheet" />

<style>
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 10px;
    }
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }
    .badge {
        font-size: 13px;
        padding: 6px 10px;
        border-radius: 12px;
    }
    .dataTables_wrapper .dataTables_filter input {
        border-radius: 20px;
        padding: 5px 12px;
    }
    .dataTables_wrapper .dt-buttons .btn {
        border-radius: 20px;
        margin-left: 5px;
    }
    .import-form input[type="file"] {
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
<div class="page-header py-3 px-3 mt-3 mb-3 bg-white shadow-sm rounded-3 border d-flex justify-content-between align-items-center flex-wrap gap-3" style="direction: rtl;">

    
    <div class="d-flex flex-column">
        <h4 class="content-title mb-1 fw-bold text-primary">إدارة الأدوار والصلاحيات</h4>
        <small class="text-muted">تحكم بالأدوار وتوزيع الصلاحيات بسهولة</small>
    </div>

    
    <div class="d-flex flex-wrap justify-content-start gap-2">
        <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-primary btn-sm d-flex align-items-center gap-1">
            <i class="bx bx-plus-circle fs-5"></i> <span>إضافة دور جديد</span>
        </a>

        
    </div>

</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">قائمة الأدوار</h5>
        <small class="text-muted">عرض جميع الأدوار مع الصلاحيات الخاصة بها</small>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table id="rolesTable" class="table table-hover table-borderless table-striped text-center align-middle">
                <thead class="bg-light">
                    <tr>
                        <th>#</th>
                        <th>اسم الدور</th>
                        <th>الصلاحيات</th>
                        <th>التحكم</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><strong><?php echo e($key + 1); ?></strong></td>
                            <td class="text-dark fw-semibold"><?php echo e($role->name); ?></td>
                            <td>
                                <?php if($role->permissions->count()): ?>
                                    <?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-primary"><?php echo e(translate_permission($perm->name)); ?>

</span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <span class="text-muted">بدون صلاحيات</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="<?php echo e(route('roles.edit', $role->id)); ?>" class="btn btn-outline-warning btn-sm">
                                        <i class="bx bx-edit-alt"></i>
                                    </a>
                                    <form action="<?php echo e(route('roles.destroy', $role->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-outline-danger btn-sm">
                                            <i class="bx bx-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<!-- Datatables JS -->
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.bootstrap5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jszip.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/buttons.print.min.js')); ?>"></script>

<script>
$(function() {
    $('#rolesTable').DataTable({
        dom: '<"row mb-3"<"col-md-6"B><"col-md-6"f>>rtip',
        buttons: [
            { extend: 'excel', text: '📊 Excel', className: 'btn btn-success btn-sm' },
            { extend: 'pdf', text: '📄 PDF', className: 'btn btn-danger btn-sm' },
            { extend: 'print', text: '🖨️ طباعة', className: 'btn btn-secondary btn-sm' }
        ],
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.1/i18n/ar.json'
        },
        pageLength: 10,
        order: [[0, 'asc']],
        responsive: true
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Thamn\resources\views/roles/index.blade.php ENDPATH**/ ?>