
<?php $__env->startSection('title', 'بيانات الشركة'); ?>

<?php $__env->startSection('css'); ?>
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(URL::asset('assets/plugins/datatable/css/buttons.bootstrap5.min.css')); ?>" rel="stylesheet" />
<style>
.page-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 30px; }
.dt-buttons .btn { background-color: #c1953e !important; border: none !important; color: #fff !important; border-radius: 8px !important; padding: 6px 12px !important; }
.dt-buttons .btn:hover { background-color: #a67f31 !important; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-header'); ?>
<div class="page-header py-3 px-3 mt-3 mb-3 bg-white shadow-sm rounded-3 border d-flex justify-content-between align-items-center flex-wrap gap-3" style="direction: rtl;">
    <div class="d-flex flex-column">
        <h4 class="content-title mb-1 fw-bold text-primary">إدارة بيانات الشركة</h4>
        <small class="text-muted">عرض جميع الأقسام والتحكم بها</small>
    </div>
    <div>
        <a href="<?php echo e(route('company-details.create')); ?>" class="btn btn-primary btn-sm d-flex align-items-center gap-1" style="background-color:#c1953e; border-color:#c1953e;">
            <i class="bx bx-plus-circle fs-5"></i> إضافة قسم جديد
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <div class="table-responsive">
            <table id="companyTable" class="table table-hover table-striped text-center align-middle">
                <thead class="bg-light">
                    <tr>
                        <th>#</th>
                        <th>القسم</th>
                        <th>العنوان (عربي)</th>
                        <th>العنوان (إنجليزي)</th>
                        <th>التحكم</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td><?php echo e($detail->section_key); ?></td>
                            <td><?php echo e($detail->title_ar); ?></td>
                            <td><?php echo e($detail->title_en); ?></td>
                            <td>
                                <div class="btn-group">
                                    <a href="<?php echo e(route('company-details.edit', $detail->id)); ?>" class="btn btn-outline-warning btn-sm"><i class="bx bx-edit-alt"></i></a>

                                    <form action="<?php echo e(route('company-details.destroy', $detail->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-outline-danger btn-sm"><i class="bx bx-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
<script>
$(document).ready(function() {
    $('#companyTable').DataTable({
        language: { url: '//cdn.datatables.net/plug-ins/1.13.1/i18n/ar.json' },
        pageLength: 10
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Filters\resources\views/company_details/index.blade.php ENDPATH**/ ?>